import request from '@/utils/request'

// 获取左侧树
export function listAiRegionManage(query) {
    return request({
      url: '/yunshou/aiRegionManage/list',
      method: 'get',
      params: query
    })
  }
  

// 获取左侧树
export function videoTreeListManage(query) {
  return request({
    url: '/yunshou/aiRegionManage/videoTreeList',
    method: 'get',
    params: query
  })
}
// 获取根据点位ID获取设备
export function idDevice(id) {
  return request({
    url: `/yunshou/aiRegionManage/getVideoInfoById/${id}`,
    method: 'get',
  })
}

// 查询设备列表x详情
export function detailDevice(id) {
    return request({
      url: `/yunshou/aiDevice/${id}`,
      method: 'get',
    })
  }

// 修改设备状态
export function updateStatusDevice(query) {
    return request({
      url: `/yunshou/aiDevice/updateStatus`,
      method: 'get',
      params: query
    })
  }
  

// 新增设备列表
export function addDevice(data) {
  return request({
    url: '/yunshou/aiDevice',
    method: 'post',
    data: data
  })
}

// 修改设备列表
export function updateDevice(data) {
    return request({
      url: '/yunshou/aiDevice',
      method: 'put',
      data: data
    })
  }
  

// 删除设备列表
export function deleteDevice(ids) {
  return request({
    url: `/yunshou/aiDevice/${ids}`,
    method: 'delete'
  })
}

// 导出设备列表
export function exportDevice(data) {
  return request({
    url: `/yunshou/aiDevice/export`,
    method: 'post',
    data: data
  })
}

