/** 
 * 新增人脸库管理
 * @param {object} params aiFacedbInfo
 * @param {string} params.createBy 
 * @param {string} params.createByName 
 * @param {object} params.createTime 
 * @param {string} params.deptId 
 * @param {string} params.faceImg 
 * @param {string} params.facedbId 
 * @param {string} params.id 
 * @param {string} params.idNumber 
 * @param {string} params.isDel 
 * @param {string} params.personName 
 * @param {string} params.phoneNumber 
 * @param {string} params.remark 
 * @param {string} params.updateBy 
 * @param {string} params.updateByName 
 * @param {object} params.updateTime 
 * @returns
 */
import request from '@/utils/request'

// 查询人脸列表
export function listFace(query) {
    return request({
      url: '/yunshou/facedb/list',
      method: 'get',
      params: query
    })
  }
  
// 新增人脸列表
export function addFace(data) {
  return request({
    url: '/yunshou/facedb',
    method: 'post',
    data: data
  })
}

// 修改人脸列表
export function updateFace(data) {
    return request({
      url: '/yunshou/facedb',
      method: 'put',
      data: data
    })
  }
  
// 删除人脸列表
export function deleteFace(ids) {
  return request({
    url: `/yunshou/facedb/${ids}`,
    method: 'delete'
  })

}
// 查询人脸详情
export function detailAlg(ids) {
  return request({
    url: `/yunshou/facedb/${ids}`,
    method: 'get',
  })
}

// 导出人脸列表
export function exportFace(data) {
  return request({
    url: `/yunshou/facedb/export`,
    method: 'post',
    data: data
  })
}
