/** 
 * 新增算法配置信息
 * @param {object} params 算法配置信息
 * @param {number} params.alarmLevel 告警等级
 * @param {string} params.algorithmEnglish 算法英文
 * @param {string} params.algorithmName 算法名称
 * @param {string} params.algorithmPlat 所属平台
 * @param {string} params.algorithmStatus 算法状态 0运行中 1已禁用
 * @param {string} params.applicationScenarios 应用场景
 * @param {string} params.cardCopywriting 卡片文案
 * @param {string} params.cardImg 卡片图案
 * @param {string} params.createBy 
 * @param {object} params.createTime 
 * @param {number} params.id 主键
 * @param {object} params.params 
 * @param {string} params.remark 
 * @param {string} params.searchValue 
 * @param {string} params.updateBy 
 * @param {object} params.updateTime 
 * @returns
 */
import request from '@/utils/request'

// 查询算法列表
export function listAlg(query) {
    return request({
      url: '/yunshou/aiAlgorithmConfig/list',
      method: 'get',
      params: query
    })
  }
  

// 查询算法文件列表
export function listAlgFile(query) {
    return request({
      url: '/yunshou/aiAlgorithmFile/list',
      method: 'get',
      params: query
    })
  }

// 查询我的算法列表
export function listMyAlg(query) {
    return request({
      url: '/yunshou/userAlgorithm/list',
      method: 'get',
      params: query
    })
  }
  
// 查询算法列表x详情
export function detailAlg(id) {
    return request({
      url: `/yunshou/aiAlgorithmConfig/${id}`,
      method: 'get',
    })
  }
  
// 查询我的算法列表详情
export function detailMyAlg(id) {
  return request({
    url: `/yunshou/userAlgorithm/${id}`,
    method: 'get',
  })
}

// 新增算法列表
export function addAlg(data) {
  return request({
    url: '/yunshou/aiAlgorithmConfig',
    method: 'post',
    data: data
  })
}

// 新增我的算法列表
export function addMyAlg(data) {
  return request({
    url: '/yunshou/userAlgorithm',
    method: 'post',
    data: data
  })
}

// 修改算法列表
export function updateAlg(data) {
    return request({
      url: '/yunshou/aiAlgorithmConfig',
      method: 'put',
      data: data
    })
  }
  
// 修改我的算法列表
export function updateMyAlg(data) {
    return request({
      url: '/yunshou/userAlgorithm',
      method: 'put',
      data: data
    })
  }

  // 修改我的算法状态
export function updateMyAlgState(data) {
  return request({
    url: '/yunshou/userAlgorithm/updateRunningState',
    method: 'post',
    data: data
  })
}


// 删除算法列表
export function deleteAlg(ids) {
  return request({
    url: `/yunshou/aiAlgorithmConfig/${ids}`,
    method: 'delete'
  })
}

// 删除我的算法列表
export function deleteMyAlg(ids) {
  return request({
    url: `/yunshou/userAlgorithm/${ids}`,
    method: 'delete'
  })
}


// 启用禁用算法
export function updateAlgState(data) {
  return request({
    url: '/yunshou/aiAlgorithmConfig/updateRunningState',
    method: 'post',
    data: data
  })
}

// 新增算法案例列表
export function addListAlgorithmCase(data) {
  return request({
    url: '/yunshou/aiAlgorithmCase/addList',
    method: 'post',
    data: data
  })
}

// 查询算法案例列表
export function listCase(query) {
  return request({
    url: '/yunshou/aiAlgorithmCase/list',
    method: 'get',
    params: query
  })
}

// 算法校验
export function checkAlg(id) {
  return request({
    url: `/yunshou/aiAlgorithmConfig/check/${id}`,
    method: 'post',
  })
}
