/**
 * 严肃声明：
 * 开源版本请务必保留此注释头信息，若删除我方将保留所有法律责任追究！
 * 本系统已申请软件著作权，受国家版权局知识产权以及国家计算机软件著作权保护！
 * 可正常分享和学习源码，不得用于违法犯罪活动，违者必究！
 * Copyright (c) 2020 陈尼克 all rights reserved.
 * 版权所有，侵权必究！
 */

import Vue from 'vue'
import VueRouter from 'vue-router'
import Home from '../views/Home.vue'
import Cart from '../views/Cart.vue'
import Category from '../views/Category.vue'
import ProductList from '../views/ProductList.vue'
import ProductDetail from '../views/ProductDetail.vue'
import User from '../views/User.vue'
import Order from '../views/Order.vue'
import OrderDetail from '../views/OrderDetail.vue'
import Setting from '../views/Setting.vue'
import Address from '../views/Address.vue'
import AddressEdit from '../views/AddressEdit.vue'
import Login from '../views/Login.vue'
import About from '../views/About.vue'
import CreateOrder from '../views/CreateOrder.vue'

Vue.use(VueRouter)

const routes = [{
  path: '/',
  name: 'home',
  redirect: '/login2'
},
{
  path: '/login',
  name: 'login',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "login" */ '../views/Login.vue'),
},
{
  path: '/home',
  name: 'home',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "home" */ '../views/Home.vue'),
},
{
  path: '/cart',
  name: 'cart',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "cart" */ '../views/Cart.vue'),
},
{
  path: '/category',
  name: 'category',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "category" */ '../views/Category.vue'),
},
{
  path: '/product-list',
  name: 'product-list',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "product-list" */ '../views/ProductList.vue'),
},
{
  path: '/product/:id',
  name: 'product',
  meta: {
    index: 3
  },
  component: () => import( /* webpackChunkName: "product" */ '../views/ProductDetail.vue'),
},
{
  path: '/user',
  name: 'user',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "user" */ '../views/User.vue'),
},
{
  path: '/order',
  name: 'order',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "order" */ '../views/Order.vue'),
},
{
  path: '/order-detail',
  name: 'order-detail',
  meta: {
    index: 3
  },
  component: () => import( /* webpackChunkName: "order-detail" */ '../views/OrderDetail.vue'),
},
{
  path: '/setting',
  name: 'setting',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "setting" */ '../views/Setting.vue'),
},
{
  path: '/address',
  name: 'address',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "address" */ '../views/Address.vue'),
},
{
  path: '/address-edit',
  name: 'address-edit',
  meta: {
    index: 3
  },
  component: () => import( /* webpackChunkName: "address-edit" */ '../views/AddressEdit.vue'),
},
{
  path: '/about',
  name: 'about',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "about" */ '../views/About.vue'),
},
{
  path: '/create-order',
  name: 'create-order',
  meta: {
    index: 2
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/CreateOrder.vue'),
},
{
  path: '/checked',
  name: 'checked',
  meta: {
    title: '检查执行',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked'),
},
{
  path: '/problem',
  name: 'problem',
  meta: {
    title: '问题上报',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked/problem'),
},
{
  path: '/list',
  name: 'list',
  meta: {
    title: '检查问题',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked/problem/list'),
},
{
  path: '/note',
  name: 'note',
  meta: {
    title: '问题记录',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked/problem/note'),
},
{
  path: '/detail',
  name: 'detail',
  meta: {
    title: '问题详情',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked/problem/note/detail'),
},
{
  path: '/edit',
  name: 'edit',
  meta: {
    title: '问题编辑',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked/problem/note/edit'),
},
{
  path: '/formwork',
  name: 'formwork',
  meta: {
    title: '问题上报表',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checked/problem/formwork'),
},
{
  path: '/correct',
  name: 'correct',
  meta: {
    title: '检查记录',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/correct'),
},
{
  path: '/notice',
  name: 'notice',
  meta: {
    title: '整改通知',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/notice'),
},
{
  path: '/noticeList',
  name: 'noticeList',
  meta: {
    title: '整改通知管理列表',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/notice/noticeList'),
},
{
  path: '/noticeListDetail',
  name: 'noticeListDetail',
  meta: {
    title: '整改通知管理详情',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/notice/noticeList/detail'),
},
{
  path: '/noticeListEdit',
  name: 'noticeListEdit',
  meta: {
    title: '整改通知管理编辑',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/notice/noticeList/edit'),
},
{
  path: '/sign',
  name: 'sign',
  meta: {
    title: '电子签名',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/notice/noticeList/sign'),
},
{
  path: '/checked-confirm',
  name: 'checked-confirm',
  meta: {
    title: '整改确认',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checkedConfirm'),
},
{
  path: '/confirmNote',
  name: 'confirmNote',
  meta: {
    title: '整改确认问题记录',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checkedConfirm/confirmNote'),
},
{
  path: '/confirmDetail',
  name: 'confirmDetail',
  meta: {
    title: '整改确认问题记录',
    index: 3
  },
  component: () => import( /* webpackChunkName: "create-order" */ '../views/checkedConfirm/confirmNote/detail'),
},
//预警记录
{
    path: '/warningNote',
    name: 'warningNote',
    meta: {
      title: '预警记录',
      index: 9
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/warningNote'),
  },
  //预警记录
{
    path: '/warning',
    name: 'warning',
    meta: {
      title: '预警提醒',
      index: 10
    },
    component: () => import(/* webpackChunkName: "create-order" */'../views/warning'),
  },
  // 预警处置
  {
    path: '/warningForm',
    name: 'warningForm',
    component: () => import('../views/warningForm'),
  },
  {
    path: '/warningNoteDetail',
    name: 'warningNoteDetail',
    meta: {
      title: '预警详情',
    },
    component: () => import('../views/warningNote/warningNoteDetail'),
  },
  {
    path: '/warningNoteEdit',
    name: 'warningNoteEdit',
    meta: {
      title: '预警编辑详情',
    },
    component: () => import('../views/warningNote/warningNoteEdit'),
  },
  {
    path: '/warningNoteList',
    name: 'warningNoteList',
    meta: {
      title: '预警记录列表',
    },
    component: () => import('../views/warningNote/warningNoteList'),
  },
// 登录页
{
  path: '/login2',
  name: 'login2',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/Login2.vue'),
},
// 消息中心
{
  path: '/message-center',
  name: 'message-center',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/messageCenter'),
},
// 安全工作台页面
{
  path: '/save-workbench',
  name: 'save-workbench',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/saveWorkbench'),
},
// 我的地盘页面
{
  path: '/my',
  name: 'my',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/my'),
},

// 安全工作台页面
{
  path: '/save-workbench',
  name: 'save-workbench',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/saveWorkbench'),
},
// 我的地盘页面
{
  path: '/my',
  name: 'my',
  meta: {
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/my'),
},



{
  path: '/add-danger',
  name: 'add-danger',
  meta: {
    title: '新增隐患',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/addDanger/addDanger'),
},
{
  path: '/choose-people',
  name: 'choose-people',
  meta: {
    title: '新增隐患',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/addDanger/manyChoosePeo'),
},

{
  path: '/report-return',
  name: 'report-return',
  meta: {
    title: '隐患上报已退回',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/reportReturn'),
},

{
  path: '/confirme-danger',
  name: 'confirme-danger',
  meta: {
    title: '隐患确认',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/confirmeDanger'),
},

{
  path: '/affirm-danger',
  name: 'affirm-danger',
  meta: {
    title: '隐患确认表单',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/confirmeDanger/confirmeDanger'),
},
{
  path: '/change-danger',
  name: 'change-danger',
  meta: {
    title: '隐患整改',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/changeDanger'),
},
{
  path: '/change-info',
  name: 'change-info',
  meta: {
    title: '隐患整改保存',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/changeDanger/changeInfo'),
},
{
  path: '/delay-info',
  name: 'delay-info',
  meta: {
    title: '隐患整改延期',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/changeDanger/delayInfo'),
},

{
  path: '/review-danger',
  name: 'review-danger',
  meta: {
    title: '隐患复查',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/reviewDanger'),
},


{
  path: '/review-add',
  name: 'review-add',
  meta: {
    title: '隐患复查新增',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/reviewDanger/reviewAdd'),
},
{
  path: '/stand-book',
  name: 'stand-book',
  meta: {
    title: '隐患台账',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/standBook'),
},

{
  path: '/normal-detail',
  name: 'normal-detail',
  meta: {
    title: '隐患详情',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/standBook/normalDetail'),
},
// 企业级督办列表
{
  path: '/supervise-danger',
  name: 'supervise-danger',
  meta: {
    title: '企业级督办',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/superviseDanger'),
},
// 企业级督办批示
{
  path: '/super-survey',
  name: 'super-survey',
  meta: {
    title: '企业级督办',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/superviseDanger/superSurvey'),
},
// 重大隐患列表
{
  path: '/major-danger',
  name: 'major-danger',
  meta: {
    title: '重大隐患',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/majorDanger'),
},
// 重大隐患审批
{
  path: '/major-survey',
  name: 'major-survey',
  meta: {
    title: '重大隐患审批',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/majorDanger/majorSurvey'),
},

// 隐患巡查首页
{
  path: '/danger-patrol',
  name: 'danger-patrol',
  meta: {
    title: '隐患巡查首页',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol'),
},
// 隐患巡查首页
{
    path: '/danger-Patrol-Time',
    name: 'danger-Patrol-Time',
    meta: {
      title: '执行巡查首页-时间管理',
      index: 1
    },
    component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/dangerPatrolTime'),
  },
  // 巡查记录首页
{
    path: '/record-Patrol-Time',
    name: 'record-Patrol-Time',
    meta: {
      title: '巡查记录首页-时间管理',
      index: 1
    },
    component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/recordPatrolTime'),
  },
// 执行巡查首页-安全管理类
{
  path: '/implement',
  name: 'implement',
  meta: {
    title: '执行巡查首页-安全管理类',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/implement'),
},
// 取消巡查
{
  path: '/cancel-patrol',
  name: 'cancel-patrol',
  meta: {
    title: '取消巡查',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/cancelPatrol'),
},
// 巡查记录
{
  path: '/record-patrol',
  name: 'record-patrol',
  meta: {
    title: '巡查记录',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/recordPatrol'),
},
// 巡查记录详情
{
  path: '/record-detail',
  name: 'record-detail',
  meta: {
    title: '巡查记录详情',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/recordPatrol/detail.vue'),
},
// 巡查统计
{
  path: '/statistics',
  name: 'statistics',
  meta: {
    title: '巡查统计',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/statistics'),
},
// 巡查审批
{
  path: '/approval-patrol',
  name: 'approval-patrol',
  meta: {
    title: '巡查审批',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/dangerPatrol/approvalPatrol'),
},





// 延期审批列表
{
  path: '/delay-approval',
  name: 'delay-approval',
  meta: {
    title: '延期审批',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/delayApproval'),
},
// 延期审批确定
{
  path: '/ratify-info',
  name: 'ratify-info',
  meta: {
    title: '延期审批',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/delayApproval/ratifyInfo'),
},

// 项目级督办列表
{
  path: '/manager-danger',
  name: 'manager-danger',
  meta: {
    title: '项目级督办',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/managerDanger'),
},
// 项目级督办批示
{
  path: '/manager-survey',
  name: 'manager-survey',
  meta: {
    title: '项目级督办',
    index: 1
  },
  component: () => import( /* webpackChunkName: "SaveWorkbench" */ '../views/danger/managerDanger/managerSurvey'),
},
{
  path: '/insert-danger',
  name: 'insert-danger',
  meta: {
    title: '我的上报',
    index: 1
  },
  component: () => import('@/views/danger/insertDanger/list')
},
{
  path: '/insert-risk',
  name: 'insert-risk',
  meta: {
    title: '我的风险上报',
    index: 1
  },
  component: () => import('@/views/risk/my-insert/index')
},
{
  path: '/risk-add',
  name: 'risk-add',
  meta: {
    title: '我的上报',
    index: 1
  },
  component: () => import('@/views/risk/riskAdd/index')
},
{
  path: '/risk-big-detail',
  name: 'risk-big-detail',
  meta: {
    title: '风险详情',
    index: 1
  },
  component: () => import('@/views/risk/riskAccount/riskBigDetail')
},
{
  path: '/risk-confirme',
  name: 'risk-confirme',
  meta: {
    title: '风险确认',
    index: 1
  },
  component: () => import('@/views/risk/riskConfirme/index')
},
// risk-affirm
{
  path: '/risk-affirm',
  name: 'risk-affirm',
  meta: {
    title: '风险确认',
    index: 1
  },
  component: () => import('@/views/risk/riskConfirme/riskAffirm')
},
// risk-account
{
  path: '/risk-account',
  name: 'risk-account',
  meta: {
    title: '风险台账',
    index: 1
  },
  component: () => import('@/views/risk/riskAccount/index')
},
// risk-return
{
  path: '/risk-return',
  name: 'risk-return',
  meta: {
    title: '上报退回',
    index: 1
  },
  component: () => import('@/views/risk/riskReturn/index')
},
// risk-confirme
{
  path: '/my-role',
  name: 'my-role',
  meta: {
    title: '我的权限',
    index: 1
  },
  component: () => import('@/views/my/role')
},
{
  path: '/message-details',
  name: 'message-details',
  meta: {
    title: '消息详情',
    index: 1
  },
  component: () => import('@/views/messageCenter/messageDetails/index')
},
{
  path: '/my-reset-pas',
  name: 'my-reset-pas',
  meta: {
    title: '修改密码',
    index: 1
  },
  component: () => import('@/views/my/resetPas')
},
{
  path: '/matrix-grad',
  name: 'matrix-grad',
  meta: {
    title: '矩阵式定级',
    index: 1
  },
  component: () => import('@/views/risk/riskAdd/matrixGrad/index')
},
{
  path: '/finish-delay-detail',
  name: 'finish-delay-detail',
  meta: {
    title: '审批详情',
    index: 1
  },
  component: () => import('@/views/danger/changeDanger/finishDelayDetail')
},
{
  path: '/my-delay',
  name: 'my-delay',
  meta: {
    title: '我的延期',
    index: 1
  },
  component: () => import('@/views/danger/myDelay/index')
},
{
  path: '/scan',
  name: 'scan',
  meta: {
    title: '',
    index: 1
  },
  component: () => import('@/views/scan/index')
},
{
  path: '/success',
  name: 'success',
  meta: {
    title: '',
    index: 1
  },
  component: () => import('@/views/common/success')
},
{
  path: '/fail',
  name: 'fail',
  meta: {
    title: '',
    index: 1
  },
  component: () => import('@/views/common/fail')
},
{
  path: '/warn',
  name: 'warn',
  meta: {
    title: '',
    index: 1
  },
  component: () => import('@/views/common/warn')
},
{
  path: '/center',
  name: 'center',
  meta: {
    title: '',
    index: 1
  },
  component: () => import('@/views/common/center')
},
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
