import router from './router'
//设置白名单，指不需要登录就可以直接进入的页面
var whiteList = ["/login2"]
//这里使用cookie.js，登录成功后将后台返回的token保存在cookie中
// Cookies.set('admin_token','token_value');
var hasToken = localStorage.getItem('admin_token');
router.beforeEach(async(to, from, next) => {
    //to: 即将要进入的目标 [路由对象]
    //from:当前导航正要离开的路由
    //next:一定要调用该方法来 resolve 这个钩子
    console.log(hasToken)
     if (hasToken) {
        if (to.path === '/login2') {
            next({ path: '/MessageCenter' })
        } else { 
            next()
        } 
      }else {
        if (whiteList.indexOf(to.path) !== -1) {
            next()//这里是即将进入的页面是白名单的页面就直接进入
        } else { 
            next({ path: '/login2' })//这里是即将进入的页面不是白名单的页面又没有token的情况下重定向到登录页面进行登录操作
        } 
      }
})