/**
 * 严肃声明：
 * 开源版本请务必保留此注释头信息，若删除我方将保留所有法律责任追究！
 * 本系统已申请软件著作权，受国家版权局知识产权以及国家计算机软件著作权保护！
 * 可正常分享和学习源码，不得用于违法犯罪活动，违者必究！
 * Copyright (c) 2020 陈尼克 all rights reserved.
 * 版权所有，侵权必究！
 */
import axios from 'axios'
import router from '../router'
import { Toast } from 'vant'; 
import { Notify } from 'vant';
import { Dialog } from 'vant';
import { getToken ,removeToken} from '@/utils/auth' // get token from cookie
const service = axios.create({
	baseURL: '/hse/app-api', //前缀路径
    headers: {//请求头部
        // "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        "content-type": "application/json",
		"data-type": "json"
	}
})
//拦截接口请求
service.interceptors.request.use(config => {
    if (getToken()) {
        config.headers['token'] = getToken()
	}
    return config
},error => {
    return Promise.reject(error)
})
service.interceptors.response.use(response => {
    const res = response.data//获取请求返回数据
    const code = response.status//获取请求响应码
    if(code == 200) {//请求响应码200 代表已经请求到接口
        if(res.code === 0) {//接口响应码0 代表接口代码运行正常
            return res
        }else if(res.code === 301){
            // Notify({ type: 'danger', message: res.msg});
            return res
        }else if(res.code === 403){
            Dialog.alert({
                title: '提示',
                message: res.msg,
                theme: 'round-button',
            }).then(() => {
                removeToken()
                location.reload()
            });
        }
    }else{
        Promise.reject(new Error('Error'))
    }
 },err=>{
    Toast.fail('请求失败');
    return Promise.reject(err)
 })
 
 export default service
 