/**
 * 严肃声明：
 * 开源版本请务必保留此注释头信息，若删除我方将保留所有法律责任追究！
 * 本系统已申请软件著作权，受国家版权局知识产权以及国家计算机软件著作权保护！
 * 可正常分享和学习源码，不得用于违法犯罪活动，违者必究！
 * Copyright (c) 2020 陈尼克 all rights reserved.
 * 版权所有，侵权必究！
 */

import Vue from 'vue'
import VueRouter from 'vue-router'
import Home from '../views/Home.vue'
import Cart from '../views/Cart.vue'
import Category from '../views/Category.vue'
import ProductList from '../views/ProductList.vue'
import ProductDetail from '../views/ProductDetail.vue'
import User from '../views/User.vue'
import Order from '../views/Order.vue'
import OrderDetail from '../views/OrderDetail.vue'
import Setting from '../views/Setting.vue'
import Address from '../views/Address.vue'
import AddressEdit from '../views/AddressEdit.vue'
import Login from '../views/Login.vue'
import About from '../views/About.vue'
import CreateOrder from '../views/CreateOrder.vue'

Vue.use(VueRouter)

const routes = [
  {
    path: '/',
    name: 'home',
    redirect: '/login2'
  },
  {
    path: '/login',
    name: 'login',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "login" */ '../views/Login.vue'),
  },
  {
    path: '/home',
    name: 'home',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "home" */ '../views/Home.vue'),
  },
  {
    path: '/cart',
    name: 'cart',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "cart" */ '../views/Cart.vue'),
  },
  {
    path: '/category',
    name: 'category',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "category" */ '../views/Category.vue'),
  },
  {
    path: '/product-list',
    name: 'product-list',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "product-list" */ '../views/ProductList.vue'),
  },
  {
    path: '/product/:id',
    name: 'product',
    meta: {
      index: 3
    },
    component: () => import(/* webpackChunkName: "product" */ '../views/ProductDetail.vue'),
  },
  {
    path: '/user',
    name: 'user',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "user" */ '../views/User.vue'),
  },
  {
    path: '/order',
    name: 'order',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "order" */ '../views/Order.vue'),
  },
  {
    path: '/order-detail',
    name: 'order-detail',
    meta: {
      index: 3
    },
    component: () => import(/* webpackChunkName: "order-detail" */ '../views/OrderDetail.vue'),
  },
  {
    path: '/setting',
    name: 'setting',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "setting" */ '../views/Setting.vue'),
  },
  {
    path: '/address',
    name: 'address',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "address" */ '../views/Address.vue'),
  },
  {
    path: '/address-edit',
    name: 'address-edit',
    meta: {
      index: 3
    },
    component: () => import(/* webpackChunkName: "address-edit" */ '../views/AddressEdit.vue'),
  },
  {
    path: '/about',
    name: 'about',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "about" */ '../views/About.vue'),
  },
  {
    path: '/create-order',
    name: 'create-order',
    meta: {
      index: 2
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/CreateOrder.vue'),
  },
  {
    path: '/checked',
    name: 'checked',
    meta: {
        title:'检查执行',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/checked'),
  },
  {
    path: '/problem',
    name: 'problem',
    meta: {
        title:'问题上报',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/checked/problem'),
  },
  {
    path: '/list',
    name: 'list',
    meta: {
        title:'检查问题',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/checked/problem/list'),
  },
  {
    path: '/note',
    name: 'note',
    meta: {
        title:'问题记录',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/checked/problem/note'),
  },
  {
    path: '/formwork',
    name: 'formwork',
    meta: {
        title:'问题上报表',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/checked/problem/formwork'),
  },
  {
    path: '/correct',
    name: 'correct',
    meta: {
        title:'检查记录',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/correct'),
  },
  {
    path: '/notice',
    name: 'notice',
    meta: {
        title:'整改通知',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/notice'),
  },
  {
    path: '/noticeList',
    name: 'noticeList',
    meta: {
        title:'整改通知管理列表',
        index: 3
    },
    component: () => import(/* webpackChunkName: "create-order" */ '../views/notice/noticeList'),
  },
  // 登录页
  {
    path: '/login2',
    name: 'login2',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "SaveWorkbench" */ '../views/Login2.vue'),
  },
  // 消息中心
   {
    path: '/message-center',
    name: 'message-center',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "SaveWorkbench" */ '../views/messageCenter'),
  },
  // 安全工作台页面
  {
    path: '/save-workbench',
    name: 'save-workbench',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "SaveWorkbench" */ '../views/saveWorkbench'),
  },
  // 我的地盘页面
  {
    path: '/my',
    name: 'my',
    meta: {
      index: 1
    },
    component: () => import(/* webpackChunkName: "SaveWorkbench" */ '../views/my'),
  },

]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
