/**
 * 严肃声明：
 * 开源版本请务必保留此注释头信息，若删除我方将保留所有法律责任追究！
 * 本系统已申请软件著作权，受国家版权局知识产权以及国家计算机软件著作权保护！
 * 可正常分享和学习源码，不得用于违法犯罪活动，违者必究！
 * Copyright (c) 2020 陈尼克 all rights reserved.
 * 版权所有，侵权必究！
 */

import Vue from 'vue'
import md5 from 'js-md5';
import App from './App.vue'
import router from './router'
import store from './store'
import util from './api/util.js'
import './permission'
import Mui from 'vue-awesome-mui';
import Cookies from 'js-cookie'
import { prefix } from '@/common/js/utils'
import { Divider, Popup, Overlay, Loading, Dialog, ContactCard, Form, AddressEdit, AddressList, Field, CellGroup, Cell,
   SwipeCell, Icon, Stepper, Card, Checkbox, CheckboxGroup, Button, Swipe, SwipeItem, PullRefresh, List, 
   Tab, Tabs, GoodsAction, GoodsActionIcon, GoodsActionButton, SubmitBar, Toast ,Search,Picker,Uploader,Notify ,ContactList,Calendar,Radio,RadioGroup,Tag,Tabbar,TabbarItem,Sticky, Grid, GridItem,Skeleton,Col,Row,  Image as VanImage, Badge,NoticeBar,DatetimePicker,
Step, Steps, ImagePreview,progress, Popover} from 'vant'
import 'lib-flexible/flexible'
import vueEsign from 'vue-esign'
import VideoPlayer from 'vue-video-player'
// 全局过滤器
import filters from "@/utils/filters.js"
Vue.prototype.util = util
Vue.use(Mui)
Vue.use(vueEsign)
Vue.use(VideoPlayer)
Vue.use(Divider).use(Popup).use(Overlay).use(Loading).use(Dialog).use(Toast).use(ContactCard).use(Form).use(AddressEdit).use(AddressList).use(Field).use(CellGroup).use(Cell).use(SwipeCell).use(Icon).use(Stepper).use(Card).use(Button).use(Swipe).use(SwipeItem).use(PullRefresh).use(List).use(Tab).use(Tabs).use(GoodsAction).use(GoodsActionIcon).use(GoodsActionButton).use(SubmitBar).use(Checkbox).use(CheckboxGroup).use(Search).use(Picker).use(Uploader).use(Notify)
.use(ContactList).use(Calendar).use(Radio).use(RadioGroup).use(Tag).use(Tabbar).use(TabbarItem).use(Sticky)
.use(Grid).use(GridItem).use(Skeleton).use(Col).use(Row).use(VanImage).use(Badge).use(NoticeBar).use(DatetimePicker)
.use(Step).use(Steps).use(ImagePreview).use(progress).use(Popover)
Vue.config.productionTip = false
new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')

Vue.prototype.$md5 = md5;
Vue.prototype.prefix = prefix;
Vue.prototype.$bus = new Vue;

Array.prototype.remove = function(val) {
  var index = this.indexOf(val);
  if (index > -1) {
    this.splice(index, 1);
  }
}

// 注册全局过滤器
Object.keys(filters).forEach(key=>{
  Vue.filter(key,filters[key])
})
